<?php
$ContentArray = array(
    // Seitentitel
    'title' => 'ECONTO® Controlling - Moderne Softwarelösungen seit 1993',

	// Description (für SEO)
    'meta_description' => 'ECONTO entwickelt maßgeschneiderte Software für Controller. Direkte Umsetzung, verlässliche Partnerschaft & fokussierte Expertise seit 1993.',

    // Header-Logo
    'header' => 'ECONTO<sup>®</sup> Controlling - seit 1993',

	// Navigation / 'url' = optional!
    'mainNav' => array(
        'home' => array('text' => 'Start', 'url' => '#home'),
        'features' => array('text' => 'Entdecken', 'url' => '#features'),
        'projects' => array('text' => 'Projekte', 'url' => '#projects'),
        'contact' => array('text' => 'Kontakt', 'url' => '#contact')
    ),
    
    // Hero-Bereich
    'hero' => array(
        'title' => 'Warum selber machen,<br>wenn man machen lassen kann?',
        'description' => 'Entdecken Sie innovative Ansätze und moderne Technologien, die Ihr Business unterstützen. Unsere Landing Page ist Ihr Tor zu spannenden Inhalten.',
        'cta1' => 'ECONTO<sup>®</sup> entdecken',
        'cta2' => 'ECONTO<sup>®</sup> kontaktieren'
    ),
    
    // Features Bereich
    'features' => array(
        'title' => 'ECONTO<sup>®</sup> entdecken',
        'items' => array(
			array(
				'id' => 'feature-direkt',
				'type' => 'feature',
				'icon' => 'M13 5.5V1L21 12L13 23V18.5C8 18.5 4 15 4 12C4 9 8 5.5 13 5.5Z',
				'title' => 'Direkte Umsetzung',
				'description' => 'Direkte Zusammenarbeit, schnelle Umsetzung Ihrer Wünsche und Konzentration auf das Wesentliche.'
			),
			array(
				'id' => 'feature-vertrauen',
				'type' => 'feature',
				'icon' => 'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z',
				'title' => 'Verlässliche Partnerschaft',
				// Kürzere, prägnantere Version
				'description' => 'Kundenbeziehungen über 10+ Jahre, basierend auf Vertrauen und Handschlagqualität.'
			),
			array(
				'id' => 'feature-modern',
				'type' => 'feature',
				'icon' => 'M16 6l2.29 2.29-4.88 4.88-4-4L2 16.59 3.41 18l6-6 4 4 6.3-6.29L22 12V6z',
				'title' => 'Seit 1993 & Modern',
				// Minimcontactal gestrafft
				'description' => 'Erfahrung seit 1993 trifft moderne Dynamik: Durch laufende Weiterbildung bleiben wir am Puls der Zeit.'
			),
			array(
				'id' => 'feature-mass',
				'type' => 'feature',
				'icon' => 'M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z',
				'title' => 'Maßgeschneiderte Software',
				// Prägnantere, direktere Variante
				'description' => 'Keine Standardlösung von der Stange, sondern Software, die exakt auf Ihre Prozesse und Anforderungen zugeschnitten ist.'
			),
        )
    ),
    
    // Projekte Bereich
	'projects' => array(
		'title' => 'ECONTO<sup>®</sup> Projekte',
		'items' => array(
			array(
				'id' => 'technologie-kompetenzen',
				'title' => 'Technologien',
				'short_description' => 'Alle Software-Systeme, Programmiersprachen und Tools in einer Übersicht',
				'icon' => 'M9.75 3.104v5.714a2.25 2.25 0 01-.659 1.591L5 14.5M9.75 3.104c-.251.023-.501.05-.75.082m.75-.082a24.301 24.301 0 014.5 0m0 0v5.714c0 .597.237 1.17.659 1.591L19.8 15.3M14.25 3.104c.251.023.501.05.75.082M19.8 15.3l-1.57.393A9.065 9.065 0 0112 15a9.065 9.065 0 00-6.23-.693L5 14.5m14.8.8l1.402 1.402c1.232 1.232.65 3.318-1.067 3.611A48.309 48.309 0 0112 21c-2.773 0-5.491-.235-8.135-.687-1.718-.293-2.3-2.379-1.067-3.61L5 14.5',
				'expanded_content' => '
					<div class="tech-list-simple">
					
					<h4>Controllingsysteme:</h4>
					<p>Cognos, Professional Planner, Corporate Planning, financialcontroller, Cubeware, SAP, SAS, ECONTO</p>
					
					<h4>Buchhaltungssysteme:</h4>
					<p>dvo, mesonic, bmd, rzl, rza, lss-schleupen, klinger, sigma, sap, navision</p>
					
					<h4>Betriebssysteme:</h4>
					<p>Mint / Ubuntu, Debian, Raspberry Pi OS, Windows</p>
					
					<h4>Office Programme:</h4>
					<p>Office-Applikationen (MS, OOO / LibreOffice)</p>
					
					<h4>Desktop Publishing, Grafik, Layout:</h4>
					<p>Gimp, Scribus, Inkscape</p>
					
					<h4>CMS-Systeme:</h4>
					<p>WordPress, RazorCMS, MediaWiki, Joomla, Typo3, eGroupware, TiddlyWiki, DokuWiki, WordPress, OpenCMS, Tiki Wiki</p>
					
					<h4>CRM / Groupware:</h4>
					<p>Goldmine, eGroupware</p>
					
					<h4>Programmiersprachen:</h4>
					<p>php, Visual Basic / VBA, AutoIt, html, Java, JavaScript, Bash, Delphi, Lazarus</p>
					
					<h4>WebDesign & Kompetenzen:</h4>
					<p>Kompozer, Frontpage, BlueGriffon, Amaya, SEO</p>
					
					</div>'
			),
			array(
				'id' => 'projekt-smarthome',
				'title' => 'Smart Home ECONTO',
				'short_description' => 'Cloud-unabhängige Smart-Home-Lösungen auf Raspberry Pi Basis für maximale Privatsphäre und Kontrolle.',
				'icon' => 'M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0 1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39z',
				'expanded_content' => '
					<p>Unsere <strong>cloud-unabhängige Smart-Home-Lösung</strong> setzt auf vollständige Datenhoheit und lokale Verarbeitung:</p>
					<ul>
						<li><strong>Hardware-Basis:</strong> Raspberry Pi für energiesparenden, flexiblen Betrieb</li>
						<li><strong>Medienzentrum:</strong> LibreELEC mit Kodi für Medienwiedergabe und Smart-Home-Steuerung</li>
						<li><strong>Privatsphäre-Fokus:</strong> Komplette Datenverarbeitung im lokalen Netzwerk, keine Cloud-Abhängigkeit</li>
						<li><strong>Flexibilität:</strong> Modular erweiterbar für individuelle Anforderungen</li>
					</ul>
					<p>Diese Lösung kombiniert die <strong>Zuverlässigkeit bewährter Open-Source-Software</strong> mit der <strong>Energieeffizienz moderner Hardware</strong> – ganz nach dem ECONTO-Prinzip: funktional, kontrollierbar und auf das Wesentliche konzentriert.</p>'
			),
			array(
				'id' => 'projekt-gmbh-rechner',
				'title' => 'ECONTO EURO GMBH RECHNER',
				'short_description' => 'Der Rechner übernimmt die genaue und verhältniswahrende Euro-Umrechnung alter Schilling-GmbHs und ermittelt automatisch die geringstmögliche, rechtlich korrekte Kapitalmaßnahme.',
				'icon' => 'M17 5.5c-3.5-1.5-8.5.5-9.5 5H4v2h3.1c1 4.5 6 6.5 9.5 5l-1-2c-2.6 1-6-.1-7-3h6v-2h-6c1-2.9 4.4-4 7-3l1-2Z',
				'expanded_content' => '
					<p>Da die Rechtslage unverändert gilt, ist die Umstellung vieler Alt-GmbHs auch heute noch notwendig.</p>
					<ul>
						<li>Gesetzeskonforme Euro-Umrechnung</li>
						<li>Automatische Berechnung der kleinsten Kapitalmaßnahme</li>
						<li>Keine Verschiebung von Beteiligungs- und Stimmrechten</li>
					</ul>
					<p>So bleibt jeder Umstellungsfall rechtssicher und ohne manuellen Rechenaufwand.</p>
					<p><a href="gmbh/" class="btn btn-primary" style="margin-top: 15px;">Zum GMBH-Rechner</a></p>'
			),
			array(
				'id' => 'controlling-software',
				'title' => 'Control Center (ecc)',
				'short_description' => 'Moderne Softwarelösung für umfassendes Cost & Profit Center Accounting',
				'icon' => 'M3 13.125C3 12.504 3.504 12 4.125 12h2.25c.621 0 1.125.504 1.125 1.125v6.75C7.5 20.496 6.996 21 6.375 21h-2.25A1.125 1.125 0 013 19.875v-6.75zM9.75 8.625c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125v11.25c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 01-1.125-1.125V8.625zM16.5 4.125c0-.621.504-1.125 1.125-1.125h2.25C20.496 3 21 3.504 21 4.125v15.75c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 01-1.125-1.125V4.125z',
				'expanded_content' => '
					<div class="software-features">
					
					<div class="feature-highlight">
						<p>Unsere Software bringt neue Energie ins Controlling und macht anspruchsvolle Analysen klarer greifbar.</p>
					</div>

					<ul>
						<li>Moderne Dashboards</li>
						<li>Präzise Auswertungen</li>
						<li>Intelligente Automatisierungen</li>
						<li>Zuverlässige Datenverarbeitung</li>
						<li>Interaktive Team-Reports</li>
					</ul>
					
					<div class="feature-benefit">
						<h4>Ihr Vorteil</h4>
						<p>So wird Controlling mit unserer Software strukturierter, fokussierter und deutlich angenehmer im täglichen Einsatz.</p>
					</div>
					
					</div>'
			),
			array(
				'id' => 'php-template-system',
				'title' => 'PHP Template-System',
				'short_description' => 'Leichtgewichtiges PHP-Template-System für schnelle und wartbare Websites – ganz ohne Datenbank und Open Source.',
				'icon' => 'M19.5 14.25v-2.625a3.375 3.375 0 00-3.375-3.375h-1.5A1.125 1.125 0 0113.5 7.125v-1.5a3.375 3.375 0 00-3.375-3.375H8.25m0 12.75h7.5m-7.5 3H12M10.5 2.25H5.625c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125V11.25a9 9 0 00-9-9z',
				'expanded_content' => '
					<ul>
						<li>Inhalte werden zentral in einem übersichtlichen PHP-Array verwaltet während modulare Funktionen Navigation, Formulare und dynamische Sektionen steuern.</li>
						<li>Das System ist Open Source (MIT) – Sie können das Projekt herunterladen und direkt sehen, wie wir arbeiten.</li>
						<li>Perfekt für Landing Pages, Portfolios oder kleine Firmenwebsites:</li>
					</ul>
					<p>sicher, SEO-freundlich und sofort einsatzbereit.</p>
					<p><a href="php_template-system/" class="btn btn-primary" style="margin-top: 15px;">Zum PHP Template-System</a></p>'

			)
		)
	),

    /* Newsletter
    'newsletter' => array(
        'title' => 'Bleiben Sie informiert',
        'description' => 'Abonnieren Sie unseren Newsletter und erhalten Sie Updates zu neuen Projekten und Features.',
        'placeholder' => 'Ihre E-Mail-Adresse',
        'button' => 'Abonnieren'
    ),
    */

    // Kontaktformular (NEU)
    'contact_form' => array(
        'title' => 'Kontaktieren Sie uns!',
        'description' => 'Sind Sie neugierig geworden? Haben Sie Anregungen oder möchten Sie ein unverbindliches Gespräch vereinbaren? Schreiben Sie uns einfach eine Nachricht oder rufen Sie uns an! Wir freuen uns!',
/*
        'fields' => array(
            'name' => array(
                'type' => 'text',
                'placeholder' => 'Ihr Name',
                'required' => true
            ),
            'email' => array(
                'type' => 'email',
                'placeholder' => 'Ihre E-Mail-Adresse',
                'required' => true
            ),
            'phone' => array(
                'type' => 'tel',
                'placeholder' => 'Ihre Telefonnummer',
                'required' => false
            ),
            'company' => array(
                'type' => 'text',
                'placeholder' => 'Ihr Unternehmen',
                'required' => false
            ),
            'message' => array(
                'type' => 'textarea',
                'placeholder' => 'Ihre Nachricht',
                'required' => true,
                'rows' => 6
            )
        ),
        'privacy_text' => 'Ich stimme zu, dass meine Angaben aus dem Kontaktformular zur Beantwortung meiner Anfrage erhoben und verarbeitet werden. Die Daten werden nach abgeschlossener Bearbeitung Ihrer Anfrage gelöscht. Hinweis: Sie können Ihre Einwilligung jederzeit für die Zukunft per E-Mail an office@econto.at widerrufen. Detaillierte Informationen zum Umgang mit Nutzerdaten finden Sie in unserer <a href="#">Datenschutzerklärung</a>.',
        'button' => 'Nachricht senden',
		'link'  =>  '../',
        'success_message' => 'Vielen Dank für Ihre Nachricht! Wir werden uns in Kürze bei Ihnen melden.',
        'error_message' => 'Es ist ein Fehler aufgetreten. Bitte versuchen Sie es später erneut oder kontaktieren Sie uns direkt unter office@econto.at.'
*/
    ),
    
    // Footer
    'footer' => array(
        'about' => array(
            'title' => 'ECONTO',
            'description' => 'Moderne Software-Lösungen für anspruchsvolle Unternehmen. Wir gestalten proaktiv die Zukunft.'
        ),
        'explore' => array(
            'title' => 'Quick-Infos',
			'details' => array(
				array('text' => 'Maßgeschneiderte Lösungen'),
				array('text' => 'Erfahrung seit 1993'),
				array('text' => 'Innovation'),
				array('text' => 'Vertrauen & Zusammenarbeit'),
				array('text' => 'Performance'),
				array('text' => 'Zukunftsfähig'),
			)
        ),
        'contact' => array(
			'title' => 'Kontakt / Impressum',
			'details' => array(
				array('text' => 'Mag. Hannes Ehrntraut'),
				array('url' => 'mailto:office@econto.at', 'text' => 'office@econto.at'),
				array('url' => 'tel:+4315045556', 'text' => '+43 1 5045556'),
				array('text' => 'Favoritenstraße 17/22'),
				array('text' => 'A-1040 Wien'),
				array('text' => 'UID: ATU43445508'),
				array('text' => 'Mitglied der Wirtschaftskammer Österreich', 'url' => 'https://firmen.wko.at/mag-hannes-ehrntraut/wien/?firmaid=c02caab1-8da8-450f-9716-b3dd1db4128c'),

			)
		),
        'copyright' => '&copy; 1993-2025 ECONTO<sup>®</sup> Controlling. Alle Rechte vorbehalten.',
        'disclaimer' => 'Diese Landing Page dient als Einstieg für weitere Unterseiten.'
    )
);
?>
