<?php
$ContentArray = array(
    'title' => 'ECONTO EURO GMBH RECHNER - Lösung für die Euro-Umstellung Ihrer GmbH',
    'meta_description' => '26 Jahre nach der Euro-Einführung: Viele GmbHs sind noch nicht umgestellt. Der ECONTO Euro GMBH-Rechner berechnet die gesetzlich korrekte Umrechnung und verhältniswahrende Kapitalmaßnahme.',
    
    'header' => 'ECONTO<sup>®</sup> Controlling',
    
    'mainNav' => array(
        'home' => array('text' => 'Zurück zur Startseite', 'url' => '../'),
		'rechner' => array('text' => 'Zum Rechner', 'url' => '../gmbh-rechner'),
    ),
    
	'hero' => array(
		'breadcrumb' => array(
			array('text' => 'Startseite', 'url' => '../'),
			array('text' => 'Euro GMBH-Rechner', 'url' => 'gmbh')
		),
        'title' => 'ECONTO EURO GMBH RECHNER',
        'description' => 'Die zeitgemäße Lösung für eine fortbestehende Herausforderung: Die rechtssichere Euro-Umstellung Ihrer Schilling-GmbH gemäß 1. Euro-JuBeG und ständiger OGH-Rechtsprechung.'
    ),
    
    'content' => array(
        'title' => 'Die Euro-Umstellung der GmbH: Eine fortbestehende Herausforderung',
        'sections' => array(
            array(
                'title' => '26 Jahre danach: Ein ungelöstes Problem',
                'content' => '<p>Entgegen der Annahme ist die Thematik der GmbH-Umstellung auf den Euro längst nicht "vom Tisch". Noch immer operieren zahlreiche Gesellschaften mit ihrem ursprünglichen, auf Schilling lautenden Gesellschaftsvertrag. Die gesetzliche Ausgangslage des 1. Euro-Justiz-Begleitgesetzes hat sich nicht geändert – und damit bleibt die mathematisch-juristische Problemstellung vollumfänglich relevant.</p>'
            ),
            array(
                'title' => 'Die persistente Realität: Noch immer nicht umgestellte "Schilling-GmbHs"',
                'content' => '<p>Für Altgesellschaften bestand nie ein absoluter Zwang zur formellen Umstellung. Viele Gesellschaften wurden daher nie notariell angepasst. Die Schillingbeträge sind zwar gemäß Euro-Einführungsverordnung als Eurobeträge zu lesen, doch eine beurkundete Anpassung unterblieb häufig.</p>
                <p>Die Notwendigkeit zur nachholenden Umstellung ergibt sich erst konkret bei bestimmten Anlässen:</p>
                <ul>
                    <li>Bei beabsichtigten Kapitalmaßnahmen (Erhöhung oder Herabsetzung des Stammkapitals)</li>
                    <li>Im Falle von Gesellschafterwechseln oder Anteilsteilungen</li>
                    <li>Bei der Neufassung des Gesellschaftsvertrages aus anderen Gründen</li>
                </ul>
                <p>In diesen Momenten tritt das alte Problem unvermittelt wieder in den Vordergrund: die exakte, verhältniswahrende Umrechnung unter Vermeidung ungewollter Verschiebungen von Beteiligungs- und Stimmrechtsverhältnissen.</p>'
            ),
            array(
                'title' => 'ECONTO antwortet auf die anhaltende Nachfrage',
                'content' => '<p>Vor diesem Hintergrund haben wir unser spezialisiertes Werkzeug für die Gegenwart und Zukunft fit gemacht. Die Nachfrage aus der Praxis – von Notaren, Rechtsanwälten und Treuhändern – ist nach wie vor präsent.</p>
                <p>Wir präsentieren daher die neu entwickelte Version des ECONTO Euro GMBH-Rechners. Diese stellt keine bloße Aktualisierung, sondern eine grundlegende Neuimplementierung in einer modernen, zukunftssicheren Programmiersprache dar:</p>
                <ul>
                    <li>Volle Kompatibilität mit aktuellen und zukünftigen Betriebssystemen</li>
                    <li>Erhöhte Stabilität und Performance</li>
                    <li>Eine intuitive Benutzeroberfläche</li>
                </ul>
                <p>Der unschätzbare Kernvorteil bleibt unverändert: die automatische, präzise Berechnung der gesetzlich korrekten Umrechnung und der geringstmöglichen verhältniswahrenden Kapitalmaßnahme gemäß der ständigen Rechtsprechung des OGH.</p>'
            ),
            array(
                'title' => 'Eine Verpflichtung für die Praxis – heute und morgen',
                'content' => '<p>Da die zugrundeliegende Rechtslage unverändert in Kraft ist, bleibt der Bedarf an einer verlässlichen Fachlösung bestehen. ECONTO bekennt sich zu dieser anhaltenden Verantwortung gegenüber der juristischen und steuerberatenden Berufswelt.</p>
                <p>Die neue Version des Euro GMBH-Rechners wird daher weiterhin Notaren, Rechtsanwälten, Wirtschaftstreuhändern und Steuerberatern als unverzichtbares Präzisionswerkzeug für die rechtssichere Abwicklung zur Verfügung gestellt. Sie steht für Kontinuität in der Qualität und Modernität in der Anwendung – bereit für die nächste Generation von Umstellungsfällen.</p>
                <p><strong>Die Euro-Umstellung der GmbH ist kein Relikt der Vergangenheit, sondern ein lebendiges Thema des Gesellschaftsrechts.</strong> Mit der neu portierten Software halten Sie das passende, zeitgemäße Instrument für dessen zuverlässige Lösung in Händen.</p>'
            )
        )
    ),
    
    'cta' => array(
        'title' => 'Bereiten Sie Ihre GmbH auf die Euro-Umstellung vor?',
        'text' => 'Nutzen Sie den neuen ECONTO Euro GMBH-Rechner für eine rechtssichere Umstellung gemäß OGH-Rechtsprechung.',
        'button' => 'Zum Rechner',
        'link' => '../gmbh-rechner'
    ),
    
    // Footer
    'footer' => array(
        'about' => array(
            'title' => 'ECONTO',
            'description' => 'Moderne Software-Lösungen für anspruchsvolle Unternehmen. Wir gestalten proaktiv die Zukunft.'
        ),
        'explore' => array(
			'title' => 'Quick-Infos',
			'description' => 'Technische Details der Software:',
			'details' => array(
				array('label' => 'Sprache:', 'value' => 'php'),
				array('label' => 'Version', 'value' => '2025/12'),
			)
		),
        'contact' => array(
			'title' => 'Kontakt / Impressum',
			'details' => array(
				array('text' => 'Mag. Hannes Ehrntraut'),
				array('url' => 'mailto:office@econto.at', 'text' => 'office@econto.at'),
				array('url' => 'tel:+4315045556', 'text' => '+43 1 5045556'),
				array('text' => 'Favoritenstraße 17/22'),
				array('text' => 'A-1040 Wien'),
				array('text' => 'UID: ATU43445508'),
				array('text' => 'Mitglied der Wirtschaftskammer Österreich', 'url' => 'https://firmen.wko.at/mag-hannes-ehrntraut/wien/?firmaid=c02caab1-8da8-450f-9716-b3dd1db4128c'),
			)
		),
        'copyright' => '&copy; 1993-2025 ECONTO<sup>®</sup> Controlling. Alle Rechte vorbehalten.',
        'disclaimer' => 'Diese Landing Page dient als Einstieg für weitere Unterseiten.'
    )
);
?>
