<?php
// Newsletter-Anmeldung verarbeiten
header('Content-Type: text/plain; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['email'])) {
    $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
    
    if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
        // Hier könnte die E-Mail in eine Datenbank gespeichert werden
        // Beispiel mit Datei:
        $file = 'newsletter_subscriptions.txt';
        $data = date('Y-m-d H:i:s') . ' - ' . $email . PHP_EOL;
        file_put_contents($file, $data, FILE_APPEND | LOCK_EX);
        
        echo "Vielen Dank für Ihre Anmeldung mit der E-Mail: " . htmlspecialchars($email);
    } else {
        echo "Bitte geben Sie eine gültige E-Mail-Adresse ein.";
    }
} else {
    echo "Ungültige Anfrage.";
}
?>
