<?php
error_reporting(E_ALL);
ini_set('display_errors', 'On');


/*
 * @ECONTO PHP TEMPLATE-SYSTEN
 * @see https://econto.at
 * @license MIT
 * Version 0.1 2025/12/09 (first release)
 * V 0.11 renderArrayBreadcrumb() erweitert für
		'breadcrumb' => array(
			array('text' => 'Startseite', 'url' => '../'),
			array('text' => 'Euro GMBH-Rechner', 'url' => 'gmbh')
		),
 */


// Inhalt der jeweiligen Seite laden
require_once 'content.php';
require_once 'cms_functions.php';
require_once 'file_functions.php';

//Dateien - mit Ausnahme von "content.php"
//in alle Unterverzeichnisse kopieren
$result = copyFilesToSubdirectories(
	['index.php', 'style.css', 'script.js',
		'file_functions.php', 'cms_functions.php',
		'newsletter-subscribe.php',
	], 
	['content.php'],
	['gmbh', 'gmbh-rechner', 'php_template-system']
	);
?>


<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?php echo htmlspecialchars($ContentArray['title'], ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); ?></title>
  <?php if (!empty($ContentArray['meta_description'])): ?>
    <meta name="description" content="<?php echo htmlspecialchars($ContentArray['meta_description'], ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); ?>">
  <?php else: ?>
    <!-- meta_description ist leer -->
  <?php endif; ?>
  <link rel="stylesheet" href="style.css">
  <!-- Weitere Meta-Tags kommen hier hinein -->
</head>

<body>
    <!-- Header & Navigation -->
    <header>
        <div class="container header-content">
            <a href="#home" class="logo">
                <span><?php echo $ContentArray['header']; ?></span>
            </a>
            
            <nav>
                <?php echo renderNavigation($ContentArray['mainNav']); ?>
            </nav>
        </div>
    </header>

    <!-- Hero-Bereich (optional) -->
    <?php if (isset($ContentArray['hero']) && !empty($ContentArray['hero']['title'])): ?>
    <section class="hero" id="home" style="text-align: center;">
        <div class="container" style="display: flex; flex-direction: column; align-items: center;">
            <?php 
            if (isset($ContentArray['hero']['breadcrumb']) && !empty($ContentArray['hero']['breadcrumb'])) {
                echo renderBreadcrumb($ContentArray['hero']['breadcrumb']);
            }
            ?>
            <h1><?php echo $ContentArray['hero']['title']; ?></h1>
            <?php if (isset($ContentArray['hero']['description']) && !empty($ContentArray['hero']['description'])): ?>
            <p><?php echo $ContentArray['hero']['description']; ?></p>
            <?php endif; ?>
            
            <?php if (isset($ContentArray['hero']['cta1']) && !empty($ContentArray['hero']['cta1'])): ?>
            <div class="cta-buttons">
                <a href="#features" class="btn btn-primary"><?php echo $ContentArray['hero']['cta1']; ?></a>
                <?php if (isset($ContentArray['hero']['cta2']) && !empty($ContentArray['hero']['cta2'])): ?>
                <a href="#contact" class="btn btn-secondary"><?php echo $ContentArray['hero']['cta2']; ?></a>
                <?php endif; ?>
            </div>
            <?php endif; ?>
        </div>
    </section>
    <?php endif; ?>

    <!-- Features-Bereich (optional) -->
    <?php if (isset($ContentArray['features']) && !empty($ContentArray['features']['title']) && isset($ContentArray['features']['items']) && !empty($ContentArray['features']['items'])): ?>
    <section class="features" id="features">
        <div class="container">
            <h2 class="section-title"><?php echo $ContentArray['features']['title']; ?></h2>
            <div class="features-grid">
                <?php foreach ($ContentArray['features']['items'] as $feature): ?>
                    <?php echo renderCard('feature', $feature); ?>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <?php endif; ?>

    <!-- Projekte-Bereich (optional) -->
    <?php if (isset($ContentArray['projects']) && !empty($ContentArray['projects']['title']) && isset($ContentArray['projects']['items']) && !empty($ContentArray['projects']['items'])): ?>
    <section class="projects" id="projects">
        <div class="container">
            <h2 class="section-title"><?php echo $ContentArray['projects']['title']; ?></h2>
            <div class="projects-grid">
                <?php foreach ($ContentArray['projects']['items'] as $project): ?>
                    <?php echo renderCard('project', $project); ?>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <?php endif; ?>

    <!-- Hauptinhalt (optional - für reine Inhaltsseiten) -->
    <?php if (isset($ContentArray['content']) && !empty($ContentArray['content']['title']) && isset($ContentArray['content']['sections']) && !empty($ContentArray['content']['sections'])): ?>
    <main class="main-content">
        <div class="container">
            <h2 class="content-title" id="thema"><?php echo $ContentArray['content']['title']; ?></h2>
            
            <?php echo renderContentSections($ContentArray['content']['sections']); ?>
            
            <!-- Call-to-Action (optional) -->
            <?php if (isset($ContentArray['cta']) && !empty($ContentArray['cta']['title'])): ?>
            <div class="cta-section">
                <h2><?php echo $ContentArray['cta']['title']; ?></h2>
                <?php if (isset($ContentArray['cta']['text']) && !empty($ContentArray['cta']['text'])): ?>
                <p><?php echo $ContentArray['cta']['text']; ?></p>
                <?php endif; ?>
                <?php if (isset($ContentArray['cta']['button']) && !empty($ContentArray['cta']['button'])): ?>
                <a href="<?php echo isset($ContentArray['cta']['link']) ? $ContentArray['cta']['link'] : '#'; ?>" class="btn btn-primary">
                    <?php echo $ContentArray['cta']['button']; ?>
                </a>
                <?php endif; ?>
            </div>
            <?php endif; ?>
        </div>
    </main>
    <?php endif; ?>

    <!-- Kontaktformular (im Newsletter-Stil) -->
	<?php if (isset($ContentArray['contact_form']) && !empty($ContentArray['contact_form'])): ?>
		<?php echo renderContactForm($ContentArray['contact_form']); ?>
	<?php endif; ?>

    <!-- Newsletter/Kontakt (optional) -->
	<?php if (isset($ContentArray['newsletter']) && !empty($ContentArray['newsletter'])): ?>
		<?php echo renderNewsletter($ContentArray['newsletter']); ?>
	<?php endif; ?>

	<!-- Footer -->
	<?php if (isset($ContentArray['footer']) && !empty($ContentArray['footer'])): ?>
		<?php echo renderFooter($ContentArray); ?>
	<?php endif; ?>

    <script src="script.js" defer></script>
</body>
</html>
