<?php
$download='../../download/econto-php_template-system.zip';

$ContentArray = array(
    'title' => 'ECONTO PHP Template-System - Leichtgewichtiges Framework für performante Websites',
    'meta_description' => 'Open-Source PHP Template-System: Zentrale Inhaltsverwaltung ohne Datenbank. Perfekt für Landing Pages, Portfolios und Firmenwebsites. MIT-Lizenz.',
    
    'header' => 'ECONTO<sup>®</sup> PHP Template-System',
    
    'mainNav' => array(
        'home' => array('text' => 'Zurück zur Startseite', 'url' => '../'),
		'download' => array('text' => 'Download', 'url' => $download),		
    ),
    
    'hero' => array(
		'breadcrumb' => array(
			array('text' => 'Startseite', 'url' => '../'),
			array('text' => 'PHP Template-System', 'url' => 'php_template-system')
		),
        'title' => 'ECONTO PHP TEMPLATE-SYSTEM',
        'description' => 'Leichtgewichtiges, datenzentriertes Framework für schnelle und wartbare Websites – ganz ohne Datenbank. Open Source mit MIT-Lizenz.'
    ),
    
    'content' => array(
        'title' => 'Das PHP Template-System: Einfachheit trifft Performance',
        'sections' => array(
            array(
                'title' => 'Leichtgewichtiges PHP-Template-System',
                'content' => '<p>Unsere Software ist ein leichtgewichtiges PHP-Template-System für schnelle und wartbare Websites – ganz ohne Datenbank. Das System verzichtet bewusst auf komplexe Datenbank-Strukturen und setzt auf eine einfache, aber mächtige PHP-Array-basierte Architektur.</p>
                <p>Durch den Verzicht auf Datenbank-Abfragen erreicht das System maximale Performance bei gleichzeitig minimaler Serverlast. Die statische Natur der Seitengenerierung ermöglicht hervorragende SEO-Ergebnisse und schnelle Ladezeiten.</p>'
            ),
            array(
                'title' => 'Zentrale Inhaltsverwaltung',
                'content' => '<p>Inhalte werden zentral in einem übersichtlichen PHP-Array verwaltet, während modulare Funktionen Navigation, Formulare und dynamische Sektionen steuern. Diese Trennung von Inhalt und Logik macht das System besonders wartungsfreundlich.</p>
                <p>Die Architektur basiert auf drei Kernkomponenten:</p>
                <ul>
                    <li><strong>content.php</strong> – Zentrale Inhaltsverwaltung in einer strukturierten Array-Form</li>
                    <li><strong>functions.php</strong> – Modulare Render-Funktionen für wiederverwendbare Komponenten</li>
                    <li><strong>index.php</strong> – Haupt-Template mit dynamischer PHP-Integration</li>
                </ul>
                <p>Diese klare Trennung ermöglicht es auch Nicht-Programmierern, Inhalte einfach zu pflegen und anzupassen.</p>'
            ),
            array(
                'title' => 'Open Source mit MIT-Lizenz',
                'content' => '<p>Das System ist Open Source und steht unter der <strong>MIT-Lizenz</strong> – Sie können das Projekt herunterladen und direkt sehen, wie wir arbeiten. Die MIT-Lizenz ist eine der freizügigsten Open-Source-Lizenzen und bietet maximale Flexibilität:</p>
                <ul>
                    <li><strong>Frei nutzbar:</strong> Für private und kommerzielle Projekte ohne Einschränkungen</li>
                    <li><strong>Frei veränderbar:</strong> Quellcode kann angepasst und modifiziert werden</li>
                    <li><strong>Frei weitergebbar:</strong> Original oder modifiziert – mit Beibehaltung des Copyright-Vermerks</li>
                </ul>
                <p>Die einzige Bedingung ist, dass der ursprüngliche Copyright-Vermerk und der Lizenztext in allen Kopien enthalten bleiben. Es gibt keine Gewährleistung und die Autoren haften nicht für Schäden.</p>'
            ),
            array(
                'title' => 'Perfekt für Landing Pages und kleine Firmenwebsites',
                'content' => '<p>Das System ist perfekt für Landing Pages, Portfolios oder kleine Firmenwebsites: sicher, SEO-freundlich und sofort einsatzbereit. Es wurde speziell für folgende Anwendungsfälle entwickelt:</p>
                <ul>
                    <li><strong>Landing Pages</strong> – Schnelle, fokussierte Präsentation von Produkten oder Dienstleistungen</li>
                    <li><strong>Portfolio-Websites</strong> – Elegante Präsentation von Arbeiten und Projekten</li>
                    <li><strong>Kleine Firmenwebsites</strong> – Professioneller Webauftritt ohne administrativen Overhead</li>
                    <li><strong>Produktpräsentationen</strong> – Fokussierte Darstellung einzelner Produkte oder Services</li>
                    <li><strong>Projektdokumentation</strong> – Strukturierte Präsentation von Projektergebnissen</li>
                </ul>
                <p>Durch das responsive Design funktioniert jede Seite optimal auf Desktop-Computern, Tablets und Smartphones.</p>'
            ),
            array(
                'title' => 'Download & Nutzung',
                'content' => '<p><strong>Sie verwenden das System bereits!</strong> Das gesamte Framework ist in den Dateien dieser Website enthalten. Laden Sie den Quellcode dieser Seite herunter oder passen Sie die Struktur für Ihr eigenes Projekt an.</p>
                <p>Das System besteht aus diesen Kern-Dateien:</p>
                <div class="file-list">
                    <div class="file-item"><span class="file-icon">📄</span> <code>content.php</code> – Zentrale Inhaltsverwaltung</div>
                    <div class="file-item"><span class="file-icon">⚙️</span> <code>functions.php</code> – Modulare Render-Funktionen</div>
                    <div class="file-item"><span class="file-icon">🎨</span> <code>index.php</code> – Haupt-Template</div>
                    <div class="file-item"><span class="file-icon">📋</span> <code>style.css</code> – Responsive Styling</div>
                    <div class="file-item"><span class="file-icon">📜</span> <code>script.js</code> – Client-seitige Interaktionen</div>
                </div>
                <p>Keine Registrierung notwendig – Sie entscheiden sich für die MIT-Lizenz, indem Sie den Lizenztext in Ihr Projekt aufnehmen.</p>'
            )
        )
    ),
    
    'cta' => array(
        'title' => 'Starten Sie mit dem PHP Template-System',
        'text' => 'Nutzen Sie unser leichtgewichtiges Framework für Ihre nächste Website – schnell, sicher und ohne Datenbank-Overhead.',
        'button' => 'Jetzt herunter laden',
        'link' => $download
    ),
    
    'footer' => array(
        'about' => array(
            'title' => 'ECONTO',
            'description' => 'Moderne Software-Lösungen für anspruchsvolle Unternehmen. Wir gestalten proaktiv die Zukunft.'
        ),
        'explore' => array(
            'title' => 'Quick-Infos',
            'description' => 'Technische Details des Systems:',
            'details' => array(
                array('label' => 'Sprache:', 'value' => 'PHP'),
                array('label' => 'Lizenz:', 'value' => 'MIT'),
                array('label' => 'Datenbank:', 'value' => 'Keine'),
                array('label' => 'Responsive:', 'value' => 'Ja')
            )
        ),
        'contact' => array(
            'title' => 'Kontakt / Impressum',
            'details' => array(
                array('text' => 'Mag. Hannes Ehrntraut'),
                array('url' => 'mailto:office@econto.at', 'text' => 'office@econto.at'),
                array('url' => 'tel:+4315045556', 'text' => '+43 1 5045556'),
                array('text' => 'Favoritenstraße 17/22'),
                array('text' => 'A-1040 Wien'),
				array('text' => 'UID: ATU43445508'),
				array('text' => 'Mitglied der Wirtschaftskammer Österreich', 'url' => 'https://firmen.wko.at/mag-hannes-ehrntraut/wien/?firmaid=c02caab1-8da8-450f-9716-b3dd1db4128c'),
            )
        ),
        'copyright' => '&copy; 1993-2025 ECONTO<sup>®</sup> Controlling. Alle Rechte vorbehalten.',
        'disclaimer' => 'PHP Template-System unter MIT-Lizenz. Download und Modifikation erlaubt mit Beibehaltung des Copyright-Vermerks.'
    )
);
?>
